<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/ColonnaInEvidenza.php";
    
    if(isset($_GET["id"])) {
        $datiColonneInEvidenza = new ColonnaInEvidenza($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $datiColonneInEvidenza->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione visualizzatore colonne in evidenza</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore colonne in evidenza creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore colonne in evidenza modificato 
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Colonne in evidenza</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($datiColonneInEvidenza)? $datiColonneInEvidenza->getNome() : "Nuovo visualizzatore colonne in evidenza"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($datiColonneInEvidenza) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($datiColonneInEvidenza) ? $datiColonneInEvidenza->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label>Nome:</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($datiColonneInEvidenza) ? $datiColonneInEvidenza->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <label>Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($datiColonneInEvidenza) && $datiColonneInEvidenza->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Numero colonne</label>
                                            <select class="form-control" name="classeColonne">
                                                <?php 
                                                    $dimenisioniSingoloArticolo = array("col-lg-8 mx-auto"=>1,"col-md-6"=>2,"col-md-4"=>3,"col-md-6 col-lg-3"=>4);
                                                    foreach($dimenisioniSingoloArticolo as $dimensione=>$numeroArticoli) {
                                                        if(isset($datiColonneInEvidenza) && $dimensione==$datiColonneInEvidenza->getClasseColonne()) {
                                                            echo"<option value=\"{$dimensione}\" SELECTED>{$numeroArticoli}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$dimensione}\">{$numeroArticoli}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Imposta un filtro per lingua sugli articoli</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div class="col-md-3 form-group">
                                            <h5>Colonna 1</h5>
                                                                                        
                                            <label  class="mt-3">Contenuto</label>
                                            <select class="selectpicker d-block" name="contenutoPrimaColonna" data-live-search="true" data-size="5" data-width="100%">
                                                <option value="0" selected>Nessuno</option>
                                                <?php 
                                                    $queryNomiTag = "SELECT * FROM geecB_contenuti";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($tag = $risNomi->fetch_assoc()) {
                                                        if(isset($datiColonneInEvidenza) && $datiColonneInEvidenza->getContenutoPrimaColonna()==$tag["id"]) {
                                                            echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Scegli un contenuto tra pagine, articoli, gallerie o elementi del portfolio</small>
                                            
                                            <label class="mt-3 d-block">Testo aggiuntivo</label>
                                            <textarea class="form-control" rows="2" name="testoPrimaColonna" aria-describedby="nome Slider"><?php echo((isset($datiColonneInEvidenza) ? $datiColonneInEvidenza->getTestoPrimaColonna() : "")) ?></textarea>
                                            <small class="text-muted">Questo testo comparirà sotto il titolo del contenuto scelto</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <h5>Colonna 2</h5>
                                                                           
                                            <label class="mt-3" >Contenuto</label>
                                            <select class="selectpicker d-block" name="contenutoSecondaColonna"  data-live-search="true" data-size="5" data-width="100%">
                                                <option value="0" selected>Nessuno</option>
                                                <?php 
                                                    $queryNomiTag = "SELECT * FROM geecB_contenuti";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($tag = $risNomi->fetch_assoc()) {
                                                        if(isset($datiColonneInEvidenza) && $datiColonneInEvidenza->getContenutoSecondaColonna()==$tag["id"]) {
                                                            echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Scegli un contenuto tra pagine, articoli, gallerie o elementi del portfolio</small>
                                            
                                            <label class="mt-3 d-block">Testo aggiuntivo</label>
                                            <textarea class="form-control" rows="2" name="testoSecondaColonna" aria-describedby="nome Slider"><?php echo((isset($datiColonneInEvidenza) ? $datiColonneInEvidenza->getTestoSecondaColonna() : "")) ?></textarea>
                                            <small class="text-muted">Questo testo comparirà sotto il titolo del contenuto scelto</small>   
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <h5>Colonna 3</h5>
  
                                            <label class="mt-3" >Contenuto</label>
                                            <select class="selectpicker" name="contenutoTerzaColonna"  data-live-search="true" data-size="5" data-width="100%">
                                                <option value="0" selected>Nessuno</option>
                                                <?php 
                                                    $queryNomiTag = "SELECT * FROM geecB_contenuti";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($tag = $risNomi->fetch_assoc()) {
                                                        if(isset($datiColonneInEvidenza) && $datiColonneInEvidenza->getContenutoTerzaColonna()==$tag["id"]) {
                                                            echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Scegli un contenuto tra pagine, articoli, gallerie o elementi del portfolio</small>
                                            
                                            <label class="mt-3 d-block">Testo aggiuntivo</label>
                                            <textarea name="testoTerzaColonna" rows="2" class="form-control" aria-describedby="Testo aggiuntivo"><?php echo((isset($datiColonneInEvidenza) ? $datiColonneInEvidenza->getTestoTerzaColonna() : "")) ?></textarea>
                                            <small class="text-muted">Questo testo comparirà sotto il titolo del contenuto scelto</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <h5>Colonna 4</h5>
                                            
                                            <label class="mt-3">Contenuto</label>
                                            <select class="selectpicker" name="contenutoQuartaColonna"  data-live-search="true" data-size="5" data-width="100%">
                                                <option value="0" selected>Nessuno</option>
                                                <?php 
                                                    $queryNomiTag = "SELECT * FROM geecB_contenuti";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($tag = $risNomi->fetch_assoc()) {
                                                        if(isset($datiColonneInEvidenza) && $datiColonneInEvidenza->getContenutoQuartaColonna()==$tag["id"]) {
                                                            echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Scegli un contenuto tra pagine, articoli, gallerie o elementi del portfolio</small>
                                            
                                            <label class="mt-3 d-block">Testo aggiuntivo</label>
                                            <textarea aria-describedby="Testo aggiuntivo" class="form-control" name="testoQuartaColonna" rows="2" aria-describedby="testo aggiuntivo"><?php echo((isset($datiColonneInEvidenza) ? $datiColonneInEvidenza->getTestoQuartaColonna() : "")) ?></textarea>
                                            <small class="text-muted">Questo testo comparirà sotto il titolo del contenuto scelto</small>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $datiColonneInEvidenza->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $datiColonneInEvidenza->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome = $('#nomeElemento').val();
                var link = $('#linkElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $datiColonneInEvidenza->getId() ?>,
                        nome:nome,
                        link:link
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $datiColonneInEvidenza->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
